#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;

#endregion

namespace gov.va.med.vbecs.GUI.controls
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carrie Van Stedum</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/13/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///Contains the blood unit selector, blood label
	/// and add the blood units list view which is a
	/// collection of selected blood units
	///</summary>

	#endregion

	public class WorklistBuilder : GUI.controls.BaseControl
	{
		#region Events

		private System.EventHandler onValidWorklist;
		private System.EventHandler onInvalidWorklist;
		private System.EventHandler onSearchClick;
		private System.EventHandler onCheckBoxesChanged;
		private System.EventHandler onUnitsInList;
		private System.EventHandler onSelectBtnClick;
		private System.EventHandler onItemCheck;
		
		#endregion

		#region Variables

		private int _itemCheckedCount = 0;			//NOt sure why this is on here
		
		//		private System.EventHandler OnUpdateUnit;
		private System.Data.DataTable dtBloodUnits;
		private bool _checkBoxes = true;

		#endregion

		#region FormControls

		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.ListView lvSelectedUnits;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ListView lvNoCheckboxesSelectedUnits;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.ColumnHeader columnHeader16;
		
		/// <summary>
		/// Blood Unit Selector user control
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.BloodUnitSelector bloodUnitSelector1;

		private System.ComponentModel.IContainer components;

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2002</CreationDate>
		/// <summary>
		/// Constructor - creates a new datatable and names it
		/// </summary>
		public WorklistBuilder()
		{
			
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			dtBloodUnits = new DataTable("BloodUnits");	
		}

		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="container">IContainer</param>
		public WorklistBuilder(System.ComponentModel.IContainer container)
		{

			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			container.Add(this);

			dtBloodUnits = new DataTable();	

		}

		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="dtBloodBags"></param>
		/// <param name="lockFunctionId"></param>
		public WorklistBuilder (System.Data.DataTable dtBloodBags, Common.LockFunctions lockFunctionId)
		{

			dtBloodUnits = new DataTable();	

			foreach(System.Data.DataRow dtRow in dtBloodBags.Rows)
			{
				BloodUnit bUnit = new BloodUnit(dtRow);
				PopulateGrid(bUnit);
			}

			InitializeComponent();
		}
		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.lvSelectedUnits = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader16 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader10 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader11 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader12 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader13 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader14 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader15 = new System.Windows.Forms.ColumnHeader();
			this.lvNoCheckboxesSelectedUnits = new System.Windows.Forms.ListView();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.bloodUnitSelector1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelector(this.components);
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.AccessibleDescription = "Selected Units";
			this.groupBox1.AccessibleName = "Selected Units";
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.lvSelectedUnits);
			this.groupBox1.Controls.Add(this.lvNoCheckboxesSelectedUnits);
			this.groupBox1.Location = new System.Drawing.Point(0, 236);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(544, 132);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Selected Units";
			// 
			// lvSelectedUnits
			// 
			this.lvSelectedUnits.AccessibleDescription = "Selected Units";
			this.lvSelectedUnits.AccessibleName = "Selected Units";
			this.lvSelectedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSelectedUnits.CheckBoxes = true;
			this.lvSelectedUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeader1,
																							  this.columnHeader2,
																							  this.columnHeader16,
																							  this.columnHeader10,
																							  this.columnHeader11,
																							  this.columnHeader12,
																							  this.columnHeader13,
																							  this.columnHeader14,
																							  this.columnHeader15});
			this.lvSelectedUnits.FullRowSelect = true;
			this.lvSelectedUnits.HideSelection = false;
			this.lvSelectedUnits.Location = new System.Drawing.Point(8, 16);
			this.lvSelectedUnits.MultiSelect = false;
			this.lvSelectedUnits.Name = "lvSelectedUnits";
			this.lvSelectedUnits.Size = new System.Drawing.Size(528, 108);
			this.lvSelectedUnits.TabIndex = 2;
			this.lvSelectedUnits.View = System.Windows.Forms.View.Details;
			this.lvSelectedUnits.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSelectedUnits_ColumnClick);
			this.lvSelectedUnits.SelectedIndexChanged += new System.EventHandler(this.lvSelectedUnits_SelectedIndexChanged);
			this.lvSelectedUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSelectedUnits_ItemCheck);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "";
			this.columnHeader1.Width = 20;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Unit ID";
			this.columnHeader2.Width = 80;
			// 
			// columnHeader16
			// 
			this.columnHeader16.Text = "Product Code";
			this.columnHeader16.Width = 78;
			// 
			// columnHeader10
			// 
			this.columnHeader10.Text = "Product";
			this.columnHeader10.Width = 120;
			// 
			// columnHeader11
			// 
			this.columnHeader11.Text = "ABO/Rh";
			// 
			// columnHeader12
			// 
			this.columnHeader12.Text = "Expires";
			this.columnHeader12.Width = 100;
			// 
			// columnHeader13
			// 
			this.columnHeader13.Text = "Status";
			this.columnHeader13.Width = 80;
			// 
			// columnHeader14
			// 
			this.columnHeader14.Text = "Donation";
			this.columnHeader14.Width = 80;
			// 
			// columnHeader15
			// 
			this.columnHeader15.Text = "Date Received";
			this.columnHeader15.Width = 100;
			// 
			// lvNoCheckboxesSelectedUnits
			// 
			this.lvNoCheckboxesSelectedUnits.AccessibleDescription = "Selected Units";
			this.lvNoCheckboxesSelectedUnits.AccessibleName = "Selected Units";
			this.lvNoCheckboxesSelectedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvNoCheckboxesSelectedUnits.CheckBoxes = true;
			this.lvNoCheckboxesSelectedUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																										  this.columnHeader4,
																										  this.columnHeader3,
																										  this.columnHeader5,
																										  this.columnHeader6,
																										  this.columnHeader7,
																										  this.columnHeader8,
																										  this.columnHeader9});
			this.lvNoCheckboxesSelectedUnits.FullRowSelect = true;
			this.lvNoCheckboxesSelectedUnits.HideSelection = false;
			this.lvNoCheckboxesSelectedUnits.Location = new System.Drawing.Point(8, 16);
			this.lvNoCheckboxesSelectedUnits.MultiSelect = false;
			this.lvNoCheckboxesSelectedUnits.Name = "lvNoCheckboxesSelectedUnits";
			this.lvNoCheckboxesSelectedUnits.Size = new System.Drawing.Size(528, 108);
			this.lvNoCheckboxesSelectedUnits.TabIndex = 2;
			this.lvNoCheckboxesSelectedUnits.View = System.Windows.Forms.View.Details;
			this.lvNoCheckboxesSelectedUnits.MouseHover += new System.EventHandler(this.lvNoCheckboxesSelectedUnits_MouseHover);
			this.lvNoCheckboxesSelectedUnits.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvNoCheckboxesSelectedUnits_ColumnClick);
			this.lvNoCheckboxesSelectedUnits.SelectedIndexChanged += new System.EventHandler(this.lvNoCheckboxesSelectedUnits_SelectedIndexChanged);
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Unit ID";
			this.columnHeader4.Width = 80;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Product";
			this.columnHeader3.Width = 120;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "ABO/Rh";
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Expires";
			this.columnHeader6.Width = 100;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Status";
			this.columnHeader7.Width = 80;
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Donation";
			this.columnHeader8.Width = 80;
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Unit-In Date";
			this.columnHeader9.Width = 100;
			// 
			// bloodUnitSelector1
			// 
			this.bloodUnitSelector1.AccessibleDescription = "Select Unit";
			this.bloodUnitSelector1.AccessibleName = "Select Unit";
			this.bloodUnitSelector1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus;
			this.bloodUnitSelector1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.bloodUnitSelector1.BloodUnit = null;
			this.bloodUnitSelector1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitSelector1.Location = new System.Drawing.Point(4, 0);
			this.bloodUnitSelector1.Name = "bloodUnitSelector1";
			this.bloodUnitSelector1.RecursionGuard = false;
			this.bloodUnitSelector1.SelectButtonEnabled = false;
			this.bloodUnitSelector1.Size = new System.Drawing.Size(536, 236);
			this.bloodUnitSelector1.TabIndex = 0;
			this.bloodUnitSelector1.UnitTable = null;
			this.bloodUnitSelector1.SelectBtnClick += new gov.va.med.vbecs.GUI.controls.BloodUnitSelector.SelectBtnClickedEventHandler(this.bloodUnitSelector1_SelectBtnClick);
			this.bloodUnitSelector1.Load += new System.EventHandler(this.bloodUnitSelector1_Load);
			this.bloodUnitSelector1.ClearBtnClick += new gov.va.med.vbecs.GUI.controls.BloodUnitSelector.ClearBtnClickedEventHandler(this.bloodUnitSelector1_ClearBtnClick);
			this.bloodUnitSelector1.SearchClick += new System.EventHandler(this.bloodUnitSelector1_SearchClick);
			// 
			// WorklistBuilder
			// 
			this.Controls.Add(this.bloodUnitSelector1);
			this.Controls.Add(this.groupBox1);
			this.Name = "WorklistBuilder";
			this.Size = new System.Drawing.Size(548, 368);
			this.Load += new System.EventHandler(this.WorklistBuilder_Load);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets table with all selected units</summary>
		[Browsable(false)]
		public System.Data.DataTable DTBloodUnits
		{
			get
			{
				return dtBloodUnits;
			}
			set
			{
				dtBloodUnits = value;
			}
		}

		

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Get SelectedBloodBags
		/// </summary>
		[Browsable(false)]
		public System.Data.DataTable SelectedBloodBags
		{
			get
			{
				System.Data.DataTable dtBloodBags = BOL.BloodUnit.GetEmptyBloodUnitDataTable().Clone();
				
				foreach(ListViewItem lvi in lvSelectedUnits.CheckedItems)
				{
					//To make sure we have the latest data, we'll grab the unit data from the DB, rather
					//than load it from the listview.
					BOL.BloodUnit freshestDataUnit = new BOL.BloodUnit(((BOL.BloodUnit)lvi.Tag).BloodUnitGuid);

					dtBloodBags.Rows.Add(freshestDataUnit.LoadDataRowFromThis(dtBloodBags.NewRow()));
				}
				return dtBloodBags;
			}
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Get SelectedBloodUnits
		/// </summary>
		[Browsable(false)]
		public System.Collections.ArrayList SelectedBloodUnits
		{
			get
			{
				System.Collections.ArrayList tmpArray = new System.Collections.ArrayList();

				foreach(ListViewItem lvi in lvSelectedUnits.CheckedItems)
				{
					//To make sure we have the latest data, we'll grab the unit data from the DB, rather
					//than load it from the listview.
					BOL.BloodUnit freshestDataUnit = new BOL.BloodUnit(((BOL.BloodUnit)lvi.Tag).BloodUnitGuid);

					tmpArray.Add(freshestDataUnit);
				}
				return tmpArray;
			}
		}

		///<Developers>
		///	<Developer>Greg "Indy" Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2003</CreationDate>
		/// <summary>
		/// Count of Selected Items in the grid
		/// </summary>
		[Browsable(false)]
		public int SelectedItems
		{
			get
			{
				//				return (lvSelectedUnits.CheckedItems.Count);
				
				//				int testVal = lvSelectedUnits.CheckedItems.Count;
				//				testVal = _itemCheckedCount;
				//				//The ItemCheck event fires before actually checking the "box", so 
				//				//we must manually keep track of the item count...Thank You Mr. Gates.
				return _itemCheckedCount;

			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		///  Gets or sets indicator to determine if checkboxes should be displayed. Editable at design time
		///  </summary>
		[
		Category("Appearance"),
		Description("Indicates whether checkboxes are displayed next to items"),
		DefaultValue("false"),
		Bindable(false),
		Browsable(true),
		]
		public bool CheckBoxes 
		{
			get 
			{ 
				return _checkBoxes;
			}
			set 
			{
				_checkBoxes = value;
				lvSelectedUnits.Visible = _checkBoxes;
				lvNoCheckboxesSelectedUnits.Visible = !_checkBoxes;
				if (onCheckBoxesChanged!=null) onCheckBoxesChanged(null,EventArgs.Empty);
			}
		}
		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets or sets docking style property
		/// </summary>
		[
		Category("Layout"),
		Description("Docking style"),
		Bindable(false),
		Browsable(true),
		]
		public override DockStyle Dock 
		{
			get { return base.Dock; }
			set { base.Dock = value; }
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2002</CreationDate>
		/// <summary>
		/// Units in list change event
		/// </summary>
		public event EventHandler UnitsInList
		{
			add 
			{ 
				onUnitsInList += value;
			}
			remove 
			{
				onUnitsInList -= value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets or sets anchor style property
		/// </summary>
		[
		Category("Layout"),
		Description("Anchor style"),
		Bindable(false),
		Browsable(true),
		]
		public override AnchorStyles Anchor
		{
			get { return base.Anchor; }
			set { base.Anchor = value; }
		}

		#endregion

		#region EventHandlers

		///<Developers>
		///	<Developer>Greg "Indy" Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/13/2003</CreationDate>
		/// <summary>
		/// Valid ItemClick event
		/// </summary>
		public event EventHandler ItemCheck
		{
			add 
			{
				onItemCheck += value;
			}
			remove 
			{ 
				onItemCheck -= value;
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Valid worklist event
		/// </summary>
		public event EventHandler ValidWorklist
		{
			add 
			{
				onValidWorklist += value;
			}
			remove 
			{ 
				onValidWorklist -= value;
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Check boxes indicator changed event
		/// </summary>
		public event EventHandler CheckBoxesChanged
		{
			add 
			{ 
				onCheckBoxesChanged += value; 
			}
			remove 
			{ 
				onCheckBoxesChanged -= value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Invalid worklist event
		/// </summary>
		public event EventHandler InvalidWorklist
		{
			add 
			{
				onInvalidWorklist += value; 
			}
			remove 
			{ 
				onInvalidWorklist -= value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Search button click event
		/// </summary>
		public event EventHandler SearchClick
		{
			add 
			{ 
				onSearchClick += value; 
			}
			remove 
			{ 
				onSearchClick -= value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Select button click event
		/// </summary>
		public event EventHandler SelectBtnClick
		{
			add
			{
				this.onSelectBtnClick += value;
			}
			remove
			{
				this.onSelectBtnClick -= value;
			}
		}

		#endregion

		#region Control Events

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Valid worklist event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnValidWorklist(object sender,System.EventArgs e)
		{
			//
		}

	
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Invalid worklist event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnInvalidWorklist(object sender,System.EventArgs e)
		{
			//
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Search button click event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnSearchClick(object sender,System.EventArgs e)
		{
			
		}

		private void bloodUnitList1_EmptyList(object sender, System.EventArgs e)
		{
			if (onInvalidWorklist != null) onInvalidWorklist(sender,e);
		}

		private void bloodUnitList1_UnitsInList(object sender, System.EventArgs e)
		{
			if (onValidWorklist != null) onValidWorklist(sender,e);
		}

		private void bloodUnitSelector1_SearchClick(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			
			if (onSearchClick != null) onSearchClick(sender,e);
		}

		private void bloodUnitSelector1_Load(object sender, System.EventArgs e)
		{
		
		}

		/// <summary>
		/// Check boxes indicator changed event handler
		/// </summary>
		/// <param name="e">Event args</param>
		protected virtual void OnCheckBoxesChanged(System.EventArgs e)
		{

		}

		/// <summary>
		/// Units in list event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnUnitsInList(object sender, System.EventArgs e)
		{
			//
		}

		/// <summary>
		/// Handles the clear button clicked event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelector1_ClearBtnClick(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			//bloodUnitSelector1.bloodBagLabel1.ClearBloodBagLabel();
		}

		/// <summary>
		/// Handles the load event of the control
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void WorklistBuilder_Load(object sender, System.EventArgs e)
		{
			
			foreach (DataRow dr in DTBloodUnits.Rows)
			{
				//BOL.BloodUnit _BloodUnit = new BOL.BloodUnit(dr,Common.LockFunctions.Unspecified);
				BOL.BloodUnit _BloodUnit = new BOL.BloodUnit(dr);
				PopulateGrid(_BloodUnit);
				if (onValidWorklist != null) 
				{
					onValidWorklist(this, new EventArgs());
				}
			}
		
		}

		/// <summary>
		/// Handles the column clicked event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			this.OnUserActivity();
			
			//lvSelectedUnits.ListViewItemSorter = new SortBySubItem(e.Column);
			//lvNoCheckboxesSelectedUnits.ListViewItemSorter = new SortBySubItem(e.Column);
			if ((e.Column == 5) || (e.Column == 8))
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvSelectedUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvSelectedUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.String);
			}

		}

		/// <summary>
		/// Handles the click event of the listview
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvNoCheckboxesSelectedUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			this.OnUserActivity();
			
			if ((e.Column == 3)||(e.Column == 6))
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvNoCheckboxesSelectedUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvNoCheckboxesSelectedUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.String);
			}

		}

		/// <summary>
		/// Handles the mouse hover event of the listview
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvNoCheckboxesSelectedUnits_MouseHover(object sender, System.EventArgs e)
		{
		
		}

		/// <summary>
		/// Handles the check event of the listview
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			this.OnUserActivity();
			this._itemCheckedCount = this.lvSelectedUnits.CheckedItems.Count;

			//This event fires before the visual implementation...so we gotta keep track
			if (e.CurrentValue == CheckState.Checked && e.NewValue == CheckState.Unchecked)
			{
				this._itemCheckedCount = this.lvSelectedUnits.CheckedItems.Count -1;
			}
			
			if(e.CurrentValue == CheckState.Unchecked && e.NewValue == CheckState.Checked)
			{
				this._itemCheckedCount = this.lvSelectedUnits.CheckedItems.Count + 1;
			}

			if (onItemCheck != null) 
			{
				//we try/catch here, so capturing event fails we can unselect the unit
				//**the capturing event would need to throw some form of error though
				try
				{
					//Pass the BloodUnit back as sender -- this will save DB trips
					//UI will not have to recreate it
					onItemCheck(lvSelectedUnits.Items[e.Index].Tag, e);
				}
				catch
				{
					e.NewValue = CheckState.Unchecked;
				}
			}

		}
		

		private void bloodUnitSelector1_SelectBtnClick(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			
			if (onSelectBtnClick != null)
			{
				try
				{
					onSelectBtnClick(sender,e);
				}
				catch(Exception)
				{
					return;
				}
			}

			BOL.BloodUnit _bloodUnit = bloodUnitSelector1.BloodUnit;

			dtBloodUnits = bloodUnitSelector1.UnitTable;
			PopulateGrid(_bloodUnit);
			if (onValidWorklist != null) onValidWorklist(sender,e);

		}
	
		#endregion

		#region Methods
		
		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/11/2006</CreationDate>
		/// <summary>
		/// Will highlight the row(s) of specified blood unit(s)
		/// </summary>
		/// <param name="bloodUnitGuidList"></param>
		public void HighlightBloodUnits(ArrayList bloodUnitGuidList)
		{
			for (int idx = 0; idx < this.lvSelectedUnits.Items.Count; idx++)
			{
				ListViewItem lviUnit = this.lvSelectedUnits.Items[idx];
				System.Guid unitGuid = ((BOL.BloodUnit)lviUnit.Tag).BloodUnitGuid;
				if (bloodUnitGuidList.Contains(unitGuid))
				{
					lviUnit.BackColor = SystemColors.WindowText;
					lviUnit.ForeColor = Color.WhiteSmoke;
				}
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/11/2006</CreationDate>
		/// <summary>
		/// Removes unit(s) from the grid
		/// </summary>
		/// <param name="bloodUnitGuidList"></param>
		public void RemoveBloodUnitsFromGrid(ArrayList bloodUnitGuidList)
		{
			for (int idx = 0; idx < this.lvSelectedUnits.Items.Count; idx++)
			{
				ListViewItem lviUnit = this.lvSelectedUnits.Items[idx];
				System.Guid unitGuid = ((BOL.BloodUnit)lviUnit.Tag).BloodUnitGuid;
				if (bloodUnitGuidList.Contains(unitGuid))
				{
					this.lvSelectedUnits.Items.Remove(lviUnit);
				}
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/05/2006</CreationDate>
		/// <summary>
		/// Clears this control, including the list view
		/// </summary>
		public void ClearControl()
		{
			this.bloodUnitSelector1.Clear(false);
			//
			// clear out the list view too
			this.lvSelectedUnits.Items.Clear();
		}

		///<Developers>
		///	<Developer>Unknown</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>Unknown</CreationDate>
		/// <summary>
		/// </summary>
		public void ResetSelectorFieldsAndErrors()
		{
			this.bloodUnitSelector1.Clear(false);
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2002</CreationDate>
		/// <summary>
		/// Populates the blood unit list view
		/// </summary>
		/// <param name="bloodUnit"></param>
		public void PopulateGrid(BOL.BloodUnit bloodUnit)
		{
			foreach (ListViewItem lviUnit in this.lvSelectedUnits.Items)
			{
				System.Guid unitGuid = ((BOL.BloodUnit)lviUnit.Tag).BloodUnitGuid;
				if (unitGuid.Equals(bloodUnit.BloodUnitGuid))
				{
					if (!lviUnit.Checked)
					{
						lviUnit.Checked = true;
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.WorklistBuilder.UnitAlreadyAdded(bloodUnit.EyeReadableUnitId, bloodUnit.FullProductCode));
					}
					return;
				}
			}
			
			ListViewItem lviCheckBoxBloodUnit  = new ListViewItem();
			
			lviCheckBoxBloodUnit.Checked = true;
			lviCheckBoxBloodUnit.Text = string.Empty;
			lviCheckBoxBloodUnit.Tag = bloodUnit;

			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.EyeReadableUnitId);
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.FullProductCode);
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.ProductShortName);
			
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.BloodUnitMedia.AboRh.AboRHText);//bloodUnit.BloodUnitMedia.BloodTypeCode + " " + bloodUnit.BloodUnitMedia.AboRh.RHFactorText);
            			
			lviCheckBoxBloodUnit.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.BloodUnitMedia.UnitExpirationDate));
			
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.BloodUnitStatus.UnitStatusDescriptiveText);

			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.DonationType.DonationTypeText);


			lviCheckBoxBloodUnit.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.IncomingShipment.ShipmentDate));
			
			lvSelectedUnits.Items.Add(lviCheckBoxBloodUnit);
			//
			controls.VbecsFunction.SetColumnWidths(this.lvSelectedUnits);
			//
			if (_checkBoxes)
			{
				if (onUnitsInList!=null) onUnitsInList(null,EventArgs.Empty);
			}
		}

		/// <summary>
		/// Allows the container of the worklistbuilder to set the listview items checkbox status
		/// Created for locking purposes -- to uncheck a unit that couldn't be locked
		/// </summary>
		/// <param name="unitGuid"></param>
		/// <param name="checkIt"></param>
		public void SetItemCheckState(System.Guid unitGuid, bool checkIt)
		{
			foreach(System.Windows.Forms.ListViewItem lvUnit in this.lvSelectedUnits.Items)
			{
				if (((BOL.BloodUnit)lvUnit.Tag).BloodUnitGuid == unitGuid)
				{
					lvUnit.Checked = checkIt;
					break;
				}
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <returns></returns>
		public string GetErrorMessages()
		{
			return this.bloodUnitSelector1.GetErrorMessages();
		}
		#endregion

		private void lvSelectedUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (lvSelectedUnits.SelectedIndices.Count > 0 && Common.LogonUser.IsVisuallyImpairedUser)
			{
				using (new WaitCursor())
				{
					System.Text.StringBuilder buildUserList = new StringBuilder();
					ListViewItem lVI = ((System.Windows.Forms.ListView) lvSelectedUnits).SelectedItems[0];
					string[] mySubItems = new string[lVI.SubItems.Count];
											
						
					for(int nCtr = 0; nCtr < lvSelectedUnits.Columns.Count; nCtr++)
					{
						if((this.lvSelectedUnits.Columns[nCtr].Text == "ABO/Rh"))
						{
							buildUserList.Append("A ");
							buildUserList.Append("B ");
							buildUserList.Append("O ");
							buildUserList.Append(" ");
							buildUserList.Append("R ");
							buildUserList.Append("H ");
							buildUserList.Append("coe lin ");
						}
						else 
						{
							if (this.lvSelectedUnits.Columns[nCtr].Text.Trim().Length > 0)
							{
								buildUserList.Append(lvSelectedUnits.Columns[nCtr].Text + "coe lin ");
								buildUserList.Append("  ");
							}
						}
						mySubItems[nCtr] = lVI.SubItems[nCtr].Text.Trim();
						if(lVI.SubItems[nCtr].Text.Trim().Length == 0)
						{
							buildUserList.Append("");
						}
						else
						{
							buildUserList.Append(mySubItems[nCtr]);
						}
						buildUserList.Append(" ");
					}
						
					string textToSpeak =buildUserList.ToString();
						
					this.SpeakMessage( textToSpeak );	
				}		
			}
		}

		private void lvNoCheckboxesSelectedUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (lvNoCheckboxesSelectedUnits.SelectedIndices.Count > 0 && Common.LogonUser.IsVisuallyImpairedUser)
			{
				using (new WaitCursor())
				{
					System.Text.StringBuilder buildUserList = new StringBuilder();
					ListViewItem lVI = ((System.Windows.Forms.ListView) lvNoCheckboxesSelectedUnits).SelectedItems[0];
					string[] mySubItems = new string[lVI.SubItems.Count];
											
						
					for(int nCtr = 0; nCtr < lvNoCheckboxesSelectedUnits.Columns.Count; nCtr++)
					{
						if((this.lvSelectedUnits.Columns[nCtr].Text == "ABO/Rh"))
						{
							buildUserList.Append("A ");
							buildUserList.Append("B ");
							buildUserList.Append("O ");
							buildUserList.Append(" ");
							buildUserList.Append("R ");
							buildUserList.Append("H ");
							buildUserList.Append("coe lin ");
						}
					    else 
						{
							if (this.lvSelectedUnits.Columns[nCtr].Text.Trim().Length > 0)
							{
								buildUserList.Append(lvSelectedUnits.Columns[nCtr].Text + "coe lin ");
								buildUserList.Append("  ");
							}
						}
						mySubItems[nCtr] = lVI.SubItems[nCtr].Text.Trim();
						if(lVI.SubItems[nCtr].Text.Trim().Length == 0)
						{
							buildUserList.Append("");
						}
						else
						{
							buildUserList.Append(mySubItems[nCtr]);
						}
						buildUserList.Append(" ");
					}
						
					string textToSpeak =buildUserList.ToString();
						
					this.SpeakMessage( textToSpeak );	
				}		
			}
		}
	}
}
